/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet.helptools;

import com.ibm.hwmca.fw.servlet.helptools.HMCHelpContentPluginDescriptor;
import com.ibm.hwmca.fw.servlet.helptools.HelpILog;
import com.ibm.hwmca.fw.servlet.helptools.HelpSupport;
import com.ibm.hwmca.fw.util.Trace;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.internal.plugins.PluginDescriptor;
import org.eclipse.core.internal.plugins.PluginRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.model.PluginDescriptorModel;
import org.eclipse.help.internal.toc.TocFile;
import org.eclipse.help.internal.toc.TocManager;

class HMCTocManager
extends TocManager {
    private static final String TRACE_MASKT = "HELPTOCT";
    private static final String TRACE_MASKF = "HELPTOCF";
    private static final String FALLBACK_LOCALE = "en_US";
    List contributingPlugins;

    public Collection getContributingPlugins() {
        return this.contributingPlugins;
    }

    protected Collection getContributedTocFiles(String locale) {
        Trace.trace(TRACE_MASKT, "Looking up help files for locale \"" + locale + "\"");
        if (this.contributingPlugins == null) {
            this.contributingPlugins = new ArrayList(5);
        }
        ArrayList<HMCTocFile> result = new ArrayList<HMCTocFile>();
        PluginDescriptor helpDescriptor = (PluginDescriptor)Platform.getPluginRegistry().getPluginDescriptor("org.eclipse.help");
        try {
            File top = new File(new URL(helpDescriptor.getLocation()).getFile());
            if (!top.isDirectory()) {
                throw new RuntimeException("Help files must be in a directory");
            }
            String[] subdirectories = top.list(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return !name.startsWith(".") && new File(dir, name).isDirectory();
                }
            });
            FilenameFilter xmlFilter = new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return !name.startsWith(".") && name.endsWith(".xml");
                }
            };
            HashMap<String, String> override = new HashMap<String, String>(1);
            override.put("$nl$", locale);
            PluginRegistry pluginRegistry = (PluginRegistry)Platform.getPluginRegistry();
            for (int bookIdx = 0; bookIdx < subdirectories.length; ++bookIdx) {
                URL helpFiles;
                File bookDir = new File(top, subdirectories[bookIdx]);
                Trace.trace(TRACE_MASKF, "Processing book in directory \"" + bookDir.getPath() + "\"");
                String pluginId = bookDir.getName();
                HMCHelpContentPluginDescriptor descriptor = (HMCHelpContentPluginDescriptor)pluginRegistry.getPlugin(pluginId);
                if (descriptor == null) {
                    try {
                        String locationAsURL = bookDir.toURL().toExternalForm();
                        descriptor = new HMCHelpContentPluginDescriptor(pluginId, locationAsURL);
                        pluginRegistry.addPlugin((PluginDescriptorModel)descriptor);
                        HelpSupport.getLoggerMap().put(descriptor.getPlugin(), HelpILog.getLogger());
                    }
                    catch (MalformedURLException e) {
                        throw new RuntimeException("Unexpected exception:", e);
                    }
                }
                if ((helpFiles = descriptor.find((IPath)new Path("$nl$"), override)) == null) {
                    Trace.trace(TRACE_MASKF, "Can't find help files for locale \"" + locale + "\" in book \"" + bookDir.getName() + "\".  Using fallback locale \"" + FALLBACK_LOCALE + "\"");
                    helpFiles = descriptor.find((IPath)new Path(FALLBACK_LOCALE));
                    if (helpFiles == null) {
                        Trace.trace(TRACE_MASKF, "Can't find help files for fallback locale either.  Skipping book.");
                        continue;
                    }
                }
                File helpFilesDir = new File(descriptor.getFileFromURL(helpFiles));
                Trace.trace(TRACE_MASKF, "Book \"" + bookDir.getName() + "\" help files found in " + helpFilesDir);
                File primaryFile = new File(helpFilesDir, "primary");
                File primaryTocFile = null;
                if (primaryFile.exists()) {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(primaryFile)));
                    String primaryTocName = reader.readLine();
                    if (primaryTocName != null && !(primaryTocFile = new File(helpFilesDir, primaryTocName)).exists()) {
                        throw new IOException("Primary TOC file \"" + primaryTocFile.getPath() + "\" doesn't exist.");
                    }
                    Trace.trace(TRACE_MASKF, "Adding \"" + primaryTocFile.getName() + "\" as primary TOC file.");
                    result.add(new HMCTocFile(descriptor, primaryTocFile.getName(), true, locale));
                    if (!this.contributingPlugins.contains((Object)descriptor)) {
                        this.contributingPlugins.add(descriptor);
                    }
                }
                String[] xmlFiles = helpFilesDir.list(xmlFilter);
                for (int i = 0; i < xmlFiles.length; ++i) {
                    File xmlFile = new File(helpFilesDir, xmlFiles[i]);
                    if (primaryTocFile != null && xmlFile.equals(primaryTocFile)) continue;
                    Trace.trace(TRACE_MASKF, "Adding \"" + xmlFile.getName() + "\" as non-primary TOC file.");
                    result.add(new HMCTocFile(descriptor, xmlFile.getName(), false, locale));
                    if (this.contributingPlugins.contains((Object)descriptor)) continue;
                    this.contributingPlugins.add(descriptor);
                }
            }
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Unexpected exception constructing toc information for locale " + locale, e);
        }
        catch (IOException e) {
            throw new RuntimeException("I/O error constructing toc information for locale " + locale, e);
        }
        Trace.trace(TRACE_MASKT, "Returning result with " + result.size() + " TOC files");
        return result;
    }

    private static class HMCTocFile
    extends TocFile {
        public HMCTocFile(PluginDescriptor descriptor, String bookHref, boolean primary, String locale) {
            super(descriptor.getId(), bookHref, primary, locale, null);
        }
    }
}

